package JavaPonies;
/*
 * This is the Pony class, full of Pony goodness
 * Basically, this holds the contents of the pony.ini file and moves the pony around
 */


import javax.swing.*;


import java.awt.*;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;


public class Pony {
	// Name of Pony
	public String Name = "";
	public String Alternate_Name = "";
	// Static picture of Pony
	public ImageIcon picture = null;
	
	// List of Behaviors (also holds the loaded animation images) 
	public List<Behavior> Behaviors = new LinkedList<Behavior>();
	
	// List of Interactions with other ponies
	public List<Interaction> Interactions = new LinkedList<Interaction>();
	
	// Interaction variables
	public boolean Interaction_Active = false;
	public Interaction Current_Interaction = null; 
	private boolean Is_Interaction_Initiator = false;
	
	public boolean Is_Interacting = false;

    //time until interactions should be disabled
    //Stops interactions from repeating too soon after one another.
    //Only affects the triggering pony and not targets
    private Date Interaction_Delay_Until = new Date();
	
	// Largest frame
	private int Largest_Size_X = 0;
	private int Largest_Size_Y = 0;
	
	// Behavior references
	private Behavior current_behavior;
	private Behavior previous_behavior;
	
	// Monitor the Pony is currently displayed on
	private GraphicsDevice Current_Screen = null;
	
	// Stop moving if the cursor is near
	private boolean Cursor_Halt = false;
	private boolean Is_cursor_halted = false;
	private boolean sleeping = false;
	
	// Destinations
	Point Destination = new Point();
	boolean AtDestination = false;
	
	// List of active effects
	public List<Effect_Form> Active_Effects = new LinkedList<Effect_Form>();
	
	// List of speaking lines
	public List<Speaking_Line> Speaking_Lines = new LinkedList<Speaking_Line>();
	
	// Reference to the window where animations are displayed 
	public Pony_Form Form;
	
	// Constructor
	public Pony(String _name, String _altname, Pony_Form _form, List<Speaking_Line> Lines) {
		// Needs to explanations
		Name = _name;
		Alternate_Name = _altname;
		Form = _form;
		
		// Set the Pony_Form speech values
		Form.SetPonyName(Name);
		Form.SetLines(Lines);
		Speaking_Lines = Lines;
	}
	
	// Add a behavior to the list of behaviors
	public void Add_Behavior(String name, double chance, double max_duration,  double min_duration,  double speed,
             String right_image_path, String left_image_path, WinMain.AllowedMoves Allowed_Moves,
             String _Linked_Behavior,  String _Startline,  String _Endline, boolean _skip,
             int _xcoord, int _ycoord, String _object_to_follow) {
		
		// Create a new behavior structure
		Behavior new_behavior = new Behavior();
		
		// Set its values
        new_behavior.Name = name.trim();
        new_behavior.Pony_Name = this.Name;
        new_behavior.chance_of_occurance = chance;
        new_behavior.MaxDuration = max_duration;
        new_behavior.MinDuration = min_duration;
        new_behavior.speed = speed;
        new_behavior.Allowed_Movement = Allowed_Moves;

        new_behavior.Start_Line_Name = _Startline;
        new_behavior.End_Line_Name = _Endline;

        new_behavior.Skip = _skip;
        
        new_behavior.destination_xcoord = _xcoord;
        new_behavior.destination_ycoord = _ycoord; 
        
        new_behavior.follow_object_name = _object_to_follow;
        
        if (_Linked_Behavior.length() > 0) {
        	new_behavior.Linked_Behavior_Name = _Linked_Behavior;
        }
        
        // This is where we load the animation image (right)
		Image imageright = load_animation(right_image_path);
        // This is where we load the animation image (left)
		Image imageleft = load_animation(left_image_path);

		// Make sure we have valid images!
		if (imageright != null && imageleft != null) {
			new_behavior.right_image = new ImageIcon(imageright);
			new_behavior.right_image_path = right_image_path;
			new_behavior.left_image = new ImageIcon(imageleft);
			new_behavior.left_image_path = left_image_path;
			
			// Determine the Pony's largest animation size
            if (new_behavior.right_image.getIconWidth() > Largest_Size_X)
            	Largest_Size_X = new_behavior.right_image.getIconWidth();
	        if (new_behavior.right_image.getIconHeight() > Largest_Size_Y)
	            Largest_Size_Y = new_behavior.right_image.getIconHeight();
            if (new_behavior.left_image.getIconWidth() > Largest_Size_X)
            	Largest_Size_X = new_behavior.left_image.getIconWidth();
	        if (new_behavior.left_image.getIconHeight() > Largest_Size_Y)
	            Largest_Size_Y = new_behavior.left_image.getIconHeight();

			new_behavior.current_image = new_behavior.right_image;
			
	        // Add this new behavior to the list
	        Behaviors.add(new_behavior);			
		}        
	}

	public void add_Interaction(String interaction_name, String name, double probability, String proximity,
			String target_list, String target_selection, String behaviorlist, int repeat_delay) throws Exception {
		
		Interaction new_interaction = new Interaction();
		
		new_interaction.Name = interaction_name;
		new_interaction.Targets_String = target_list;
		new_interaction.PonyName = name;
		new_interaction.Probability = probability;
		new_interaction.Reactivation_Delay = repeat_delay;
		
		if (target_selection.trim().equalsIgnoreCase("all") || target_selection.trim().equalsIgnoreCase("true"))
			new_interaction.Select_All_Targets = true;
		else if (target_selection.trim().equalsIgnoreCase("random") || target_selection.trim().equalsIgnoreCase("false"))
			new_interaction.Select_All_Targets = false;
		else
			throw new Exception("Invalid option for target selection. Use either 'random' or 'all'.\n"
	                + " Interaction file specified: " + target_selection +
	                " for interaction named: " + interaction_name);
	
		if (!proximity.trim().equalsIgnoreCase("default")) {
			new_interaction.Proximity_Activation_Distance = Double.parseDouble(proximity);
		}
		
		String[] targets = WinMain.currentInstance.SplitWithQualifiers(target_list, ",", "\"");
		String[] interaction_behaviors = WinMain.currentInstance.SplitWithQualifiers(behaviorlist, ",", "\"");
		
		for (String iBehavior : interaction_behaviors) {
			boolean found = false;
			
			for (Behavior behavior : this.Behaviors) {
				if (iBehavior.trim().equalsIgnoreCase(behavior.Name)) {
					new_interaction.Behavior_List.add(behavior);
					found = true;
				}
			}
			if (!found) {
				// Debug output
				System.out.println("Warning: Pony '" + this.Name + "' does not have required behavior '" + iBehavior + "' for interaction: '" +
	                   interaction_name + "'. This interaction is disabled.");
				
				return;
			}
		}
		
		List<String> ok_targets = new LinkedList<String>();
		
		for (String target : targets) {
			boolean ponyfound = false;
			
			for (Pony pony : WinMain.currentInstance.Active_Ponies) {
				if (target.trim().equalsIgnoreCase(pony.Name.trim())) {
					ponyfound = true;
					
					ok_targets.add(pony.Name);
					
					for (String behavior : interaction_behaviors) {
						boolean found = false;
						
						for (Behavior ponybehavior : pony.Behaviors) {
							if (behavior.trim().equalsIgnoreCase(ponybehavior.Name)) {
								found = true;
								break;
							}
						}
						
						if (!found) {
							ok_targets.remove(pony.Name);
							// Debug output
							System.out.println("Warning:  Pony " + pony.Name + " (" + pony.Alternate_Name + ") " +
	                                " does not have required behavior '" +
	                                behavior + "' as specified in interaction " + interaction_name +
	                                "\nInteraction is disabled for this pony.");
						}
					}
				}
			}
			
			if (!ponyfound) {
				// Debug output
				System.out.println("Warning: There is no pony with name " + target + " loaded.  Interaction '" + name +
	                       "' has this pony listed as a target.");
			}
		}
		
		if (ok_targets.size() > 0 && new_interaction.Behavior_List.size() > 0) {
			for (String PonyName : ok_targets) {
				new_interaction.Interacts_With_Names.add(PonyName);
			}
			
			Interactions.add(new_interaction);
		}
	}

	public void Cancel_Interaction() {
		Is_Interacting = false;
		
		if (Current_Interaction != null) {
			if (this.Is_Interaction_Initiator) {
				for(Pony pony : Current_Interaction.Interacts_With) {
					pony.Cancel_Interaction();
				}
			}
		
			Interaction_Delay_Until = new Date((new Date()).getTime() + (Current_Interaction.Reactivation_Delay * 1000));
			
			Current_Interaction = null;
			Is_Interaction_Initiator = false;
		}
	}

	// Create a clone of this Pony
	public Pony Duplicate() throws Exception {
		Pony newpony = new Pony(Name, Alternate_Name, new Pony_Form(), Speaking_Lines);
		
		// Copy behaviors
		for (Behavior behavior : Behaviors) {
			newpony.Add_Behavior(behavior.Name, behavior.chance_of_occurance, behavior.MaxDuration, behavior.MinDuration, behavior.speed, behavior.right_image_path, behavior.left_image_path, behavior.Allowed_Movement, behavior.Linked_Behavior_Name, behavior.Start_Line_Name, behavior.End_Line_Name, behavior.Skip, behavior.destination_xcoord, behavior.destination_ycoord, behavior.follow_object_name);
		}
		
		newpony.Link_Behaviors();
		
		// Copy effects
		for (Behavior behavior : Behaviors) {
			for (Behavior new_behavior : newpony.Behaviors) {
				if (behavior.Name.equals(new_behavior.Name)) {
					for (effect effect : behavior.Effects) {
						new_behavior.Effects.add(effect);
					}
					break;
				}
			}
		}
		
		// Copy interactions
		for (Interaction Interact : Interactions) {
			String targets = Interact.Targets_String;
			String behaviors = Interact.getBehaviors();
			
			if (targets.length() > 0 && behaviors.length() > 0) {
				newpony.add_Interaction(Interact.Name, newpony.Name, Interact.Probability, Double.toString(Interact.Proximity_Activation_Distance), targets, Boolean.toString(Interact.Select_All_Targets), behaviors, Interact.Reactivation_Delay);
			}
		}
		
		return newpony;
	}
	
	// Set the animation based on the direction we are being forced to move to
	public Behavior GetAppropriateBehavior(WinMain.AllowedMoves movement, boolean speed, Behavior specified_behavior) {
		double selected_behavior_speed = 0;
		Behavior selected_behavior = current_behavior;

		//does the current behavior work?  /use current behavior images when following
		if ((movement == WinMain.AllowedMoves.None && (current_behavior.Allowed_Movement == WinMain.AllowedMoves.None || current_behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver)) ||
				(movement == WinMain.AllowedMoves.Diagonal_Only && (current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Only || current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical)) ||
				(movement == WinMain.AllowedMoves.Vertical_Only && (current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical || current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || current_behavior.Allowed_Movement == WinMain.AllowedMoves.Vertical_Only)) ||
				(movement == WinMain.AllowedMoves.Horizontal_Only && (current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Only)) ||
				(movement == current_behavior.Allowed_Movement) ||
				(movement == WinMain.AllowedMoves.All)
				) {
			if (current_behavior.speed == 0 && movement == WinMain.AllowedMoves.None)
				return current_behavior;
			
			if (current_behavior.speed != 0 && movement == WinMain.AllowedMoves.All)
				return current_behavior;
		}
		
		// Loop through the list of behaviors
		for (Behavior behavior : Behaviors) {
			if ((movement == WinMain.AllowedMoves.None && (behavior.Allowed_Movement == WinMain.AllowedMoves.None || behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver)) ||
				(movement == WinMain.AllowedMoves.Diagonal_Only && (behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Only || behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical)) ||
				(movement == WinMain.AllowedMoves.Vertical_Only && (behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical || behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || behavior.Allowed_Movement == WinMain.AllowedMoves.Vertical_Only)) ||
				(movement == WinMain.AllowedMoves.Horizontal_Only && (behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Only)) ||
				(movement == behavior.Allowed_Movement) ||
				(movement == WinMain.AllowedMoves.All)
				) {
				if (behavior.Skip == false) {
					if (behavior.speed == 0 && movement != WinMain.AllowedMoves.All) {
						if (Form.PonyDirection == true)
							behavior.right = true;
						else
							behavior.right = false;
						
						return behavior;
					} else {
						// see if the specified behavior works. If not, we'll find another.
						if (specified_behavior != null) {
							if ((movement == WinMain.AllowedMoves.None && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.None || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver)) ||
								(movement == WinMain.AllowedMoves.Diagonal_Only && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Only || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical)) ||
								(movement == WinMain.AllowedMoves.Vertical_Only && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Vertical_Only)) ||
								(movement == WinMain.AllowedMoves.Horizontal_Only && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Only)) ||
								(movement == specified_behavior.Allowed_Movement) ||
								(movement == WinMain.AllowedMoves.All)
								) {
								if (Destination.x == 0 && Destination.y == 0) {
									if (Form.PonyDirection == true)
										specified_behavior.right = true;
									else
										specified_behavior.right = false;
								} else {
									if (Get_Destination_Direction(Destination).get(0) == WinMain.Directions.right)
										specified_behavior.right = true;
									else
										specified_behavior.right = false;
								}
								
								return specified_behavior;
							}
						}
						
						// If we are not following anything 
						if (behavior.destination_xcoord == 0 && behavior.destination_ycoord == 0 && behavior.follow_object_name.length() == 0) {
							// Are we running?
							if (speed) {
								// Find the behavior with the greatest speed
								if (Math.abs(behavior.speed) > selected_behavior_speed) {
									selected_behavior = behavior;
									selected_behavior_speed = Math.abs(behavior.speed);
								}
							} else {
								// Otherwise find the behavior with the smallest speed
								if (Math.abs(behavior.speed) < selected_behavior_speed || selected_behavior_speed == 0) {
									selected_behavior = behavior;
									selected_behavior_speed = Math.abs(behavior.speed);
								}
							}
						}
					}
				}
			}
		}
		
		// Return the behavior we found
		return selected_behavior;
	}

	// Get the effect's location based on the direction, centering, pony size and effect size
	private Point GetEffectLocation(int width, int height, WinMain.Directions direction, Pony_Form PonyForm, WinMain.Directions centering) {
		Point point = null;
		
		switch(direction) {
			case bottom:
				point = new Point(PonyForm.getLocation().x + (PonyForm.getWidth() / 2), PonyForm.getLocation().y + PonyForm.getHeight());
				break;
			case bottom_left:
				point = new Point(PonyForm.getLocation().x, PonyForm.getLocation().y + PonyForm.getHeight());
				break;
			case bottom_right:
				point = new Point(PonyForm.getLocation().x + PonyForm.getWidth(), PonyForm.getLocation().y + PonyForm.getHeight());
				break;
			case center:
				point = new Point(PonyForm.getLocation().x + (PonyForm.getWidth() / 2), PonyForm.getLocation().y + (PonyForm.getHeight() / 2));
				break;
			case left:
				point = new Point(PonyForm.getLocation().x, PonyForm.getLocation().y + (PonyForm.getHeight() / 2));
				break;
			case right:
				point = new Point(PonyForm.getLocation().x + PonyForm.getWidth(), PonyForm.getLocation().y + (PonyForm.getHeight() / 2));
				break;
			case top:
				point = new Point(PonyForm.getLocation().x + (PonyForm.getWidth() / 2), PonyForm.getLocation().y);
				break;
			case top_left:
				point = new Point(PonyForm.getLocation().x, PonyForm.getLocation().y);
				break;
			case top_right:
				point = new Point(PonyForm.getLocation().x + PonyForm.getWidth(), PonyForm.getLocation().y);
				break;
		}
		
		switch(centering) {
			case bottom:
				point = new Point(point.x - (width / 2), point.y - height);
				break;
	        case bottom_left:
				point = new Point(point.x, point.y - height);
				break;
	        case bottom_right:
				point = new Point(point.x - width, point.y - height);
				break;
	        case center:
				point = new Point(point.x - (width / 2), point.y - (height / 2));
				break;
	        case left:
				point = new Point(point.x, point.y - (height / 2));
				break;
	        case right:
				point = new Point(point.x - width, point.y - (height / 2));
				break;
	        case top:
				point = new Point(point.x - (width / 2), point.y);
				break;
	        case top_left:
				// no change
				break;
	        case top_right:
				point = new Point(point.x - width, point.y);
				break;
		}
		
		return point;
	}

	// Get a random direction for effects
	private WinMain.Directions GetRandomDirection(boolean IncludeCentered) {
		int dice;
		if (IncludeCentered)
			dice = WinMain.rand.nextInt(9);
		else
			dice = WinMain.rand.nextInt(8);
		
		switch(dice) {
			case 0:
				return WinMain.Directions.bottom;
			case 1:
				return WinMain.Directions.bottom_left;
			case 2:
				return WinMain.Directions.bottom_right;
			case 3:
				return WinMain.Directions.left;
			case 4:
				return WinMain.Directions.right;
			case 5:
				return WinMain.Directions.top;
			case 6:
				return WinMain.Directions.top_left;
			case 7:
				return WinMain.Directions.top_right;
			case 8:
			default:
				return WinMain.Directions.center;
		}
	}
	
	// Get the direction we need to go to reach a destination
	private List<WinMain.Directions> Get_Destination_Direction(Point destination) {
		List<WinMain.Directions> direction = new LinkedList<WinMain.Directions>();
		
		// Do we need to go left or right?
		if (destination.x - Form.getLocation().x <= 0)
			direction.add(WinMain.Directions.left);
		else
			direction.add(WinMain.Directions.right);
		
		// Do we need to go up or down?
		if (destination.y - Form.getLocation().y <= 0)
			direction.add(WinMain.Directions.top);
		else
			direction.add(WinMain.Directions.bottom);
		
		return direction;
	}
	
	public void Initialize_Interactions() {
		for (Interaction Interact : Interactions) {
			for (String Name : Interact.Interacts_With_Names) {
				for (Pony pony : WinMain.currentInstance.Active_Ponies) {
					if (Name.equalsIgnoreCase(pony.Name.trim())) {
						boolean already_added = false;
						for (Pony other_Pony : Interact.Interacts_With) {
							if (other_Pony == pony) {
								already_added = true;
								break;
							}
						}
						
						if (!already_added)
							Interact.Interacts_With.add(pony);
					}
				}
			}
		}
	}
	
	// Is the location in the defined screen avoidance area?
	public boolean IsPonyInAvoidanceArea(Point location, GraphicsDevice screen) {
		if (screen == null || Current_Screen == null) return false;
		
		if (Current_Screen.getIDstring() != screen.getIDstring()) return false;
				
		Rectangle screenBounds = screen.getDefaultConfiguration().getBounds();
		
        Rectangle screen_avoidance_area = new Rectangle((int)(((Options.Avoidance_Loc_X * screenBounds.getWidth()) / 100) + screenBounds.getMinX()),
                (int)(((Options.Avoidance_Loc_Y * screenBounds.getHeight()) / 100) + screenBounds.getMinY()),
                (int)((Options.Avoidance_Size_X * screenBounds.getWidth()) / 100),
                (int)((Options.Avoidance_Size_Y * screenBounds.getHeight()) / 100));
        
        if (screen_avoidance_area.intersects(new Rectangle(location, new Dimension(10, 10)))) {
        	return true;
        }

		return false;
	}

	// Is the location near the mouse cursor?
	public boolean IsPonyNearMouseCursor(Point location) {
		// Ignore this check if the option is set to false, or if we are in manual control
		if (Options.Cursor_Avoidance_Enabled && !this.Is_Interacting && !Form.ManualControl) {
	        Rectangle forbidden_zone = new Rectangle(MouseInfo.getPointerInfo().getLocation().x - Options.Cursor_zone_counter, MouseInfo.getPointerInfo().getLocation().y - Options.Cursor_zone_counter, Options.Cursor_zone_counter*2, Options.Cursor_zone_counter*2);
	
	        Point pony_location = new Point(location.x + (Largest_Size_X / 2), location.y + (Largest_Size_Y / 2));
	        
	        if (forbidden_zone.contains(pony_location)) {
	        	return true;
	        }
		}
		
		return false;
	}

	// Is the location somewhere on screen?
	public boolean IsPonyOnScreen(Point current_location, Point new_location, GraphicsDevice[] AllScreens) {
		List<Point> points = new LinkedList<Point>();
		points.add(new_location);
		points.add(new Point(new_location.x + this.Form.getWidth(), new_location.y + this.Form.getHeight()));
		points.add(new Point(new_location.x + this.Form.getWidth(), new_location.y));
		points.add(new Point(new_location.x, new_location.y + this.Form.getHeight()));

		for (Point point : points) {
			boolean ok = false;

			// Check every selected monitor to see if the location is there 
			for (GraphicsDevice Screen : AllScreens) {
				Rectangle screenBounds = Screen.getDefaultConfiguration().getBounds();
				
				if (screenBounds.contains(point)) {
					ok = true;
					Current_Screen = Screen; // If so, update the current monitor reference
					break;
				}
			}
			
			if (ok == false)
				return false;
		}
		
		// All still ok
		return true;
	}

	public Interaction Is_In_Interaction_Range() {
		if ((new Date()).getTime() <= Interaction_Delay_Until.getTime()) return null;
		
		for (Interaction Interact : Interactions) {
			for (Pony target : Interact.Interacts_With) {
                // don't start an interaction if we or the target haven't finished loading yet
				if (Form.CurrentImage != null && target.Form.CurrentImage != null && !target.Is_Interacting) {
					double distance = Math.sqrt(Math.pow(Form.getLocation().getX() + Form.getSize().getWidth() - target.Form.getLocation().getX() + target.Form.getSize().getWidth(), 2) + Math.pow(Form.getLocation().getY() + Form.getSize().getHeight() - target.Form.getLocation().getY() + target.Form.getSize().getHeight(),2));;
					
					if (distance <= Interact.Proximity_Activation_Distance) {
						double dice = WinMain.rand.nextDouble();
						
						if (dice <= Interact.Probability) {
							Interact.Trigger = target;
							return Interact;
						}
					}
				}
			}
		}
		
		return null;
	}

	// Link behaviors directly if a linked behavior value was set
	public void Link_Behaviors() {
		for (Behavior behavior : Behaviors) {
			if (behavior.Linked_Behavior_Name.length() == 0) {
				behavior.Linked_Behavior = null;
			} else {
				for (Behavior other_behavior : Behaviors) {
					if (behavior.Linked_Behavior_Name.equalsIgnoreCase(other_behavior.Name)) {
						behavior.Linked_Behavior = other_behavior;
						break;
					}
				}
			}
			
			if (behavior.End_Line_Name.length() > 0) {
				for (Speaking_Line line : Speaking_Lines) {
					if (line.Name.equalsIgnoreCase(behavior.End_Line_Name)) {
						behavior.End_Line = line;
						break;
					}
				}
			}
			
			if (behavior.Start_Line_Name.length() > 0) {
				for (Speaking_Line line : Speaking_Lines) {
					if (line.Name.equalsIgnoreCase(behavior.Start_Line_Name)) {
						behavior.Start_Line = line;
						break;
					}
				}
			}
		}
	}

	// Load an image from path
	private Image load_animation(String ponyimage_path) {
		Image image = null;
		try {
			image = Toolkit.getDefaultToolkit().createImage(ponyimage_path);
		} catch(Exception e) {
			// Debug output
			System.out.println("Could not load image: " + ponyimage_path);
			System.out.println(e.getMessage());
		}
		return image;
	}

	// Move the Pony
	public void Move() {
		current_behavior.blocked = false;
		
		Point current_location = Form.getLocation();
		
		double speed = current_behavior.speed;
		
		// If we are in manual control, set the behavior (animation), direction and speed
		if (Form.ManualControl) {
			if (!Form.PonyUp && !Form.PonyDown && !Form.PonyRight && !Form.PonyLeft) {
				speed = 0;
				current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.None, Form.PonySpeed, null);
			} else if (Form.PonyUp && Form.PonyRight) {
				Form.PonyDirection = true;
				current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, Form.PonySpeed, null);
			    speed = current_behavior.speed;
			    current_behavior.right = true;
			    current_behavior.vertical = true;
			    current_behavior.horizontal = true;
			    current_behavior.up = true;
	        } else if (Form.PonyDown && Form.PonyRight) {
	            Form.PonyDirection = true;
	            current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, Form.PonySpeed, null);
	            speed = current_behavior.speed;
	            current_behavior.right = true;
	            current_behavior.vertical = true;
	            current_behavior.horizontal = true;
	            current_behavior.up = false;
	        } else if (Form.PonyDown && Form.PonyLeft) {
	            Form.PonyDirection = false;
	            current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, Form.PonySpeed, null);
	            speed = current_behavior.speed;
	            current_behavior.right = false;
	            current_behavior.vertical = true;
	            current_behavior.horizontal = true;
	            current_behavior.up = false;
	        } else if (Form.PonyUp && Form.PonyLeft) {
	            Form.PonyDirection = false;
	            current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, Form.PonySpeed, null);
	            speed = current_behavior.speed;
	            current_behavior.right = false;
	            current_behavior.vertical = true;
	            current_behavior.horizontal = true;
	            current_behavior.up = true;
	        } else if (Form.PonyUp) {
	        	current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Vertical_Only, Form.PonySpeed, null);
	            speed = current_behavior.speed;
	            current_behavior.vertical = true;
	            current_behavior.horizontal = false;
	            current_behavior.up = true;
	        } else if (Form.PonyDown) {
	        	current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Vertical_Only, Form.PonySpeed, null);
	            speed = current_behavior.speed;
	            current_behavior.vertical = true;
	            current_behavior.horizontal = false;
	            current_behavior.up = false;
	        } else if (Form.PonyRight) {
	            Form.PonyDirection = true;
	            current_behavior.right = true;
	            current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Horizontal_Only, Form.PonySpeed, null);
	            speed = current_behavior.speed;
	            current_behavior.vertical = false;
	            current_behavior.horizontal = true;
	        } else if (Form.PonyLeft) {
	            Form.PonyDirection = false;
	            current_behavior.right = false;
	            current_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Horizontal_Only, Form.PonySpeed, null);
	            speed = current_behavior.speed;
	            current_behavior.vertical = false;
	            current_behavior.horizontal = true;
	        }
	
	    	if (Form.PonySpeed) {
	    		speed = current_behavior.speed * 2;
	    	}
		}
		
		// Get the destination for following (will be blank(0,0) if not following)
		Destination = current_behavior.Get_Destination(Current_Screen, this);
		
		// Calculate the movement speed
		double x_movement = 0;
		double y_movement = 0;
		
		// If following something...
	    if (Destination.x != 0 || Destination.y != 0) {
	    	// Calculate the distance to this point
	    	double distance = Math.sqrt(Math.pow(Form.getLocation().getX() - Destination.getX(), 2) + Math.pow(Form.getLocation().getY() - Destination.getY(),2));
	    	
	    	List<WinMain.Directions> direction = Get_Destination_Direction(Destination);
	    	
            try {
            	// Calculate the horizontal and vertical movement speeds
                if (direction.get(0) == WinMain.Directions.left) {
                    x_movement = (int)((Form.getLocation().getX() - Destination.getX()) / (distance) * -speed);
                    current_behavior.right = false;
                } else {
                    x_movement = (int)((Destination.getX() - Form.getLocation().getX()) / (distance) * speed);
                    current_behavior.right = true;
                }
                
                y_movement = (int)((Form.getLocation().getY() - Destination.getY()) / (distance) * -speed);
            } catch(Exception ex) {
                //overflow due to distance being 0
                x_movement = 0;
                y_movement = 0;
            }
	    	
	    	// Determine if we are close enough to it
	        if (distance <= (current_behavior.current_image.getIconWidth() / 2)) {
	        	// If so, don't move anymore
	            x_movement = 0;
	            y_movement = 0;
	
	            AtDestination = true;
	
	            //reached destination.
	            if (current_behavior.Linked_Behavior != null && current_behavior.speed != 0) {
	                current_behavior.end_time = new Date();
	                Destination = new Point();
	            }
	        } else { // Otherwise, we need to move towards it
	            if (AtDestination == true) {
	                current_behavior.delay = 10;
	            }
	
	            if (current_behavior.delay > 0) {
	                AtDestination = false;
	                current_behavior.delay--;
	                return;
	            }
	
	            AtDestination = false;
	        }
	    } else { // If we aren't following anything
	        if (!current_behavior.right) {
	            speed = -speed;
	        }
	    
	        // Calculate the movement speed normally
			x_movement = current_behavior.horizontal ? speed : 0;
			y_movement = current_behavior.vertical ? speed : 0;
		
			if (current_behavior.up) {
				if (y_movement > 0) {
					y_movement = -y_movement;
				}
			} else {
				if (y_movement < 0) {
					y_movement = -y_movement;
				}
			}
	    }
		
		// Point to determine where we would end up at this speed
	    
	    //Note:  Converting from double to int as this version does not have precise coordinates yet.
		Point new_location = new Point(current_location.x + (int)x_movement, current_location.y + (int)y_movement);
		
	    //if we ARE currently in the cursor's zone, then say that we should be halted (cursor_halt), save our current behavior so we 
	    //can continue later, and set the current behavior to nothing so it will be changed.
	    if (IsPonyNearMouseCursor(current_location)) {
	        Cursor_Halt = true;
	        Paint(); //enabled effects on mouseover.
	        return;
	    } else {
	        //if we're not in the cursor's way, but still flagged that we are.  Exit now
	        //so that we call SelectBehavior again so we can change back to the previous one before the halt.
	        if (Is_cursor_halted) {
	            Cursor_Halt = false;
	            return;
	        }
	    }
	
	    // if we are heading into the cursor, change directions
	    if (IsPonyNearMouseCursor(new_location)) {
	        Cursor_Halt = false;
	        
	        // if we are moving to a destination, our path is blocked, and we need to abort the behavior
	        // if we are just moving normally, just "bounce" off of the barrier.
	        if (Destination.x == 0 && Destination.y == 0)
	        	current_behavior.Bounce(this, current_location, new_location, x_movement, y_movement, Current_Screen);
	        else
	        	current_behavior = null;
	        
	        return;
	    }
	
	    if (IsPonyOnScreen(current_location, new_location, WinMain.screens_to_use) && !IsPonyInAvoidanceArea(new_location, Current_Screen)) {
	        Form.setLocation(new_location);
	        Paint();
	        
	        // check to see if we should interact at all
	        if (Options.Interactions_Enabled && !Is_Interacting) {
	        	Interaction Interact = Is_In_Interaction_Range();
	        	
	        	if (Interact != null) {
	        		Start_Interaction(Interact);
	        	}
	        }
	        return;
	    } else {
	        //The new move puts us off screen!
	        //Sanity check time - are we even on screen now?
	        if (IsPonyInAvoidanceArea(current_location, WinMain.screens_to_use[0]) || IsPonyOnScreen(new_location, current_location, WinMain.screens_to_use) == false) {
	            //we are no where! Teleport!
	            Teleport();
	            return;
	        }
	    }
	
	    //Nothing to worry about, we are on screen, but our current behavior would take us 
	    // off-screen in the next move.  Just do something else.
	    // if we are moving to a destination, our path is blocked, and we need to abort the behavior
	    // if we are just moving normally, just "bounce" off of the barrier.
	
	    if (Destination.x == 0 && Destination.y == 0) {
	    	current_behavior.Bounce(this, current_location, new_location, x_movement, y_movement, Current_Screen);
	    } else {
	    	if (current_behavior.follow_object == null) {
	    		current_behavior = null;
	    	} else {
	    		//do nothing but stare longenly in the direction of the object we want to follow...
	    		current_behavior.blocked = true;
	    		Paint();
	    	}
	    }
	}

	// Change the behavior if the mouse is being hovered over the Pony
	public void MouseOver_Mode() {
	    //Should be halted, so halting now.
	    if (Cursor_Halt && !Is_cursor_halted) {
	        Is_cursor_halted = true;
	
	        previous_behavior = current_behavior;
	
	        //Select the first behavior...
	        current_behavior = Behaviors.get(0);
	
	        //...or one that is marked for mouseover mode
	        for (Behavior behavior : Behaviors) {
	            if (behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver) {
	                current_behavior = behavior;
	                break;
	            }
	        }
	        
	        Paint();
	    }
	
	    //Returning out of being halted
	    if (!Cursor_Halt && Is_cursor_halted) {
	        current_behavior = previous_behavior;
	        Is_cursor_halted = false;
	        Paint();
	    }
	}

	// Change the pony's animation and handle effects
	private void Paint() {
		// Get the left and right images
		ImageIcon right_image = current_behavior.right_image;
		ImageIcon left_image = current_behavior.left_image;
		
		// Verify if we are following something
		if (Destination.x != 0 || Destination.y != 0) {
			// Calculate the horizontal and vertical distance 
	        double horizonal = Math.abs(Destination.getX() - Form.getLocation().getX());
	        double vertical = Math.abs(Destination.getY() - Form.getLocation().getY());
	        Behavior appropriate_behavior = null;
	        WinMain.AllowedMoves allowed_movement = WinMain.AllowedMoves.All;
	
	        // Calculate the real distance
	        double distance = Math.sqrt(Math.pow(Form.getLocation().getX() - Destination.getX(), 2) + Math.pow(Form.getLocation().getY() - Destination.getY(), 2));
	
	        // Determine if we want to move horizontally, diagonaly or vertically
	        if (distance >= current_behavior.current_image.getIconWidth() * 2) {
	            if (horizonal * 0.75 > vertical && allowed_movement == WinMain.AllowedMoves.Horizontal_Only) {
	            	
	            } else {
	            	switch (allowed_movement) {
	            		case All:
	            		case Diagonal_Vertical:
	            		case Horizontal_Vertical:
	            		case Vertical_Only:
	    	                allowed_movement = WinMain.AllowedMoves.Vertical_Only;
	    	                break;
	    	            default:
	    	            	allowed_movement = WinMain.AllowedMoves.None;
	    	            	break;
	            	}
	            }
	        }
	     
	        // If we are already at destination or blocked
	        if (AtDestination || current_behavior.blocked || current_behavior.speed == 0)
	            allowed_movement = WinMain.AllowedMoves.None; // We are not allowed to move
	
	        // Find the animation best suited for where we are going
	        if (Is_Interacting)
	        	appropriate_behavior = GetAppropriateBehavior(allowed_movement, true, current_behavior);
	        else
	        	appropriate_behavior = GetAppropriateBehavior(allowed_movement, true, null);
	
	        // Get this animation's left and right images
	        left_image = appropriate_behavior.left_image;
	        right_image = appropriate_behavior.right_image;
		}
	
		// Set the correct image to the behavior (left or right)
	    if (current_behavior.right)
	        current_behavior.current_image = right_image;
	    else
	        current_behavior.current_image = left_image;
		
		// Change the pony animation if necessary
	    if (Form.CurrentImage == null || current_behavior.current_image != Form.Pony_Image.getIcon()) {
	    	current_behavior.current_image.getImage().flush();
	    	Form.Pony_Image.setIcon(current_behavior.current_image);
	    	Form.observeImage(current_behavior.current_image);
	    	Form.setSize(current_behavior.current_image.getIconWidth(), current_behavior.current_image.getIconHeight());
	    	Form.CurrentImage = current_behavior.current_image;
	    }
	
	    // Remove effects
		List<Effect_Form> Effects_to_Remove = new LinkedList<Effect_Form>();
	
        for (Effect_Form effect : this.Active_Effects) {
        	if (!effect.isVisible()) {
        		Effects_to_Remove.add(effect);
        	} else {
        		if (effect.Close_On_New_Behavior) {
        			if (!current_behavior.Name.trim().equalsIgnoreCase(effect.Behavior_Name.trim())) {
        				effect.setVisible(false);
        				Effects_to_Remove.add(effect);
        			}
        		}
        		
        		if (effect.Follows)
        			effect.setLocation(GetEffectLocation(effect.Effect_Image.getIcon().getIconWidth(), effect.Effect_Image.getIcon().getIconHeight(), effect.direction, Form, effect.centering));
        	}
        }
        
        for (Effect_Form effect : Effects_to_Remove) {
            this.Active_Effects.remove(effect);
        }
	    
	    // Verify if we can create effects
	    if (Options.Effects_Enabled == true) {
	    	// Loop through the effects for this behavior
	        for (effect effect : current_behavior.Effects) {
	        	// Determine if we should initialize or repeat the behavior
	            if (((new Date()).getTime() - effect.last_used.getTime()) >= (effect.repeat_delay * 1000)) {
	            	// If the effect has no repeat delay, only show once
	            	if (effect.repeat_delay != 0 || effect.already_played_for_currentbehavior == false) {
	            		effect.already_played_for_currentbehavior = true;
	            				
		                Effect_Form effect_form = new Effect_Form();
	
		                if (current_behavior.right)
		                	effect_form.setSize(effect.right_image.getIconWidth(), effect.right_image.getIconHeight());
		                else
		                	effect_form.setSize(effect.left_image.getIconWidth(), effect.right_image.getIconHeight());
		                
		                effect_form.setVisible(true);
		                
		                // Set the duration of the effect
		                if (effect.duration != 0) {
		                    effect_form.End_Time = new Date((new Date()).getTime() + Math.round(effect.duration * 1000));
		                	effect_form.Close_On_New_Behavior = false;
		                } else {
		                	if (this.Is_cursor_halted)
		                		effect_form.End_Time = new Date((new Date()).getTime() + Math.round(current_behavior.MaxDuration * 1000));
		                	else
		                		effect_form.End_Time = current_behavior.end_time;
		                	
		                    effect_form.Close_On_New_Behavior = true;
		                }
	
		                // Show the effect form
		                effect_form.setName(Name + "'s " + effect.name);
		                
		                // Load the effect animation
		                if (current_behavior.right) {
			                effect.right_image.getImage().flush();
			                effect_form.Effect_Image.setIcon(effect.right_image);
			                effect_form.observeImage(effect.right_image);
			                effect_form.direction = effect.placement_direction_right;
			                effect_form.centering = effect.centering_right;
		                } else {
			                effect.left_image.getImage().flush();
			                effect_form.Effect_Image.setIcon(effect.left_image);
			                effect_form.observeImage(effect.left_image);
			                effect_form.direction = effect.placement_direction_left;
			                effect_form.centering = effect.centering_left;
		                }
		                
		                if (effect_form.direction == WinMain.Directions.random)
		                	effect_form.direction = GetRandomDirection(true);
		                if (effect_form.centering == WinMain.Directions.random)
		                	effect_form.centering = GetRandomDirection(true);
		                if (effect_form.direction == WinMain.Directions.random_not_center)
		                	effect_form.direction = GetRandomDirection(false);
		                if (effect_form.centering == WinMain.Directions.random_not_center)
		                	effect_form.centering = GetRandomDirection(false);
		
		                // Initialize the effect values
		                effect_form.Follows = effect.follow;
		                effect_form.effect_name = effect.name;
		                effect_form.Behavior_Name = current_behavior.Name;
		
		                // Position the effect's initial location and size
		                if (current_behavior.right) {
			                effect_form.setLocation(GetEffectLocation(effect.right_image.getIconWidth(), effect.right_image.getIconHeight(), effect_form.direction, Form, effect_form.centering));
			                effect_form.setSize(effect.right_image.getIconWidth(), effect.right_image.getIconHeight());
		                } else {
			                effect_form.setLocation(GetEffectLocation(effect.left_image.getIconWidth(), effect.left_image.getIconHeight(), effect_form.direction, Form, effect_form.centering));
			                effect_form.setSize(effect.left_image.getIconWidth(), effect.left_image.getIconHeight());
		                }
		                
		                // Add the effect to the list of active effects
		                WinMain.currentInstance.Active_Effects.add(effect_form);
		                this.Active_Effects.add(effect_form);
		                
		                // Set the timestamp
		                effect.last_used = new Date();
	                }
	            }
	        }
	    }
	}

	// Select a new behavior (animation) to perform
	public void SelectBehavior(Behavior Specified_Behavior) {
		if (Is_Interacting && Specified_Behavior == null) Cancel_Interaction();
		
		double dice;
		
		int selection = 0;
		
		// Are we being forced into a specific behavior or not?
		if (Specified_Behavior == null) {
			int loop_total = 0;
			
			// Randomly select a non-skip behavior
			while(loop_total <= 200) {
				dice = WinMain.rand.nextDouble();
				
				selection = WinMain.rand.nextInt(Behaviors.size());
				if (dice <= Behaviors.get(selection).chance_of_occurance && Behaviors.get(selection).Skip == false) {
					Behaviors.get(selection).follow_object = null;
	
					if (Current_Screen == null)
						Current_Screen = WinMain.screens_to_use[0];
	
	                Destination = Behaviors.get(selection).Get_Destination(Current_Screen, this);
	
	                if (!(Destination.x == 0 && Destination.y == 0 && Behaviors.get(selection).follow_object_name.length() > 0)) {
						current_behavior = Behaviors.get(selection);
						break;
	                }
				}
				loop_total++;
			}
			
			if (loop_total > 200) {
				// If the Random number generator is being goofy, select the default behavior (usually standing)
				current_behavior = Behaviors.get(0);
			}				
		} else { // Set the forced behavior that was specified
			Destination = Specified_Behavior.Get_Destination(Current_Screen, this);

			if (Destination.x == 0 && Destination.y == 0 && Specified_Behavior.follow_object_name.length() > 0) {
				SelectBehavior(null);
				return;
			}
			current_behavior = Specified_Behavior;
			current_behavior.follow_object = null;
		}
		
		for (effect Effect : current_behavior.Effects) {
			Effect.already_played_for_currentbehavior = false;
		}
		
		// Set the time this behavior will last
        current_behavior.end_time = new Date((new Date()).getTime() + Math.round(WinMain.rand.nextDouble() * (current_behavior.MaxDuration - current_behavior.MinDuration) * 1000 + (current_behavior.MinDuration * 1000)));
	    
		// Select facing (left or right)
		dice = WinMain.rand.nextDouble();
		if (dice >= 0.5)
			current_behavior.right = true;
		else
			current_behavior.right = false;
		
		// Determine if the Pony should speak now
	    dice = WinMain.rand.nextDouble();
	    if (current_behavior.Start_Line != null) {
	        Form.Pony_Speak(Current_Screen, current_behavior.Start_Line, false);
	    } else if (current_behavior.End_Line == null &&
	    		current_behavior.follow_object_name.length() == 0 &&
	    		dice <= Options.Pony_Speak_Chance_Counter * 0.01) {
	        Form.Pony_Speak(Current_Screen, null, false);
	    }
	
	    // If we aren't moving anywhere, stop here
	    if ((current_behavior.Allowed_Movement == WinMain.AllowedMoves.None) || (current_behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver) ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Sleep) {
	        current_behavior.horizontal = false;
	        current_behavior.vertical = false;
	        return;
	    }
	    
	    // Otherwise, randomly select the movement direction based on where we're allowed to move
	    List<WinMain.AllowedMoves> modes = new LinkedList<WinMain.AllowedMoves>();
	    if (current_behavior.Allowed_Movement == WinMain.AllowedMoves.All ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Vertical_Only) {
	    	modes.add(WinMain.AllowedMoves.Vertical_Only);
	    }
	    if (current_behavior.Allowed_Movement == WinMain.AllowedMoves.All ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Only) {
	    	modes.add(WinMain.AllowedMoves.Diagonal_Only);
	    }
	    if (current_behavior.Allowed_Movement == WinMain.AllowedMoves.All ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Only ||
	    		current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical) {
	    	modes.add(WinMain.AllowedMoves.Horizontal_Only);
	    }
	    
	    if (modes.size() == 0) {
	    	System.out.println("Unhandled movement type in SelectBehavior()");
	    	return;
	    }
	    
	    selection = WinMain.rand.nextInt(modes.size());
	    WinMain.AllowedMoves selected_mode = modes.get(selection);
	    
	    switch(selected_mode) {
	    	case Vertical_Only:
	    		current_behavior.horizontal = false;
	    		current_behavior.vertical = true;
	    		break;
	    	case Diagonal_Only:
	    		current_behavior.horizontal = true;
	    		current_behavior.vertical = true;
	    		break;
	    	case Horizontal_Only:
	    		current_behavior.horizontal = true;
	    		current_behavior.vertical = false;
	    		break;
	    }
	    
	    dice = WinMain.rand.nextDouble();
	    
	    if (dice >= 0.5)
	    	current_behavior.up = true;
	    else
	    	current_behavior.up = false;
	    
	    dice = WinMain.rand.nextDouble();
	    
	    if (dice >= 0.5)
	    	current_behavior.right = true;
	    else
	    	current_behavior.right = false;
	}

	public void sleep() {
		for (Effect_Form effect : Active_Effects) {
			effect.setVisible(false);
		}
		Behavior sleep_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.Sleep, false, null);
		if (sleep_behavior.Allowed_Movement != WinMain.AllowedMoves.Sleep) {
			sleep_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.MouseOver, false, null);
			if (sleep_behavior.Allowed_Movement != WinMain.AllowedMoves.MouseOver) {
				sleep_behavior = GetAppropriateBehavior(WinMain.AllowedMoves.None, false, null);
			}
		}
		SelectBehavior(sleep_behavior);
		current_behavior.end_time = new Date();
		Paint();
		sleeping = true;
	}
	
	public void Start_Interaction(Interaction interaction) {
		Is_Interaction_Initiator = true;
		Current_Interaction = interaction;
		this.SelectBehavior(interaction.Behavior_List.get(WinMain.rand.nextInt(interaction.Behavior_List.size())));
		for (effect Effect : current_behavior.Effects) {
			Effect.already_played_for_currentbehavior = false;
		}
		
		if (interaction.Select_All_Targets) {
			for (Pony pony : interaction.Interacts_With) {
				pony.Start_Interaction_As_Target(current_behavior.Name, this, interaction);
			}
		} else {
			interaction.Trigger.Start_Interaction_As_Target(current_behavior.Name, this, interaction);
		}
		
		Is_Interacting = true;
	}
	
	public void Start_Interaction_As_Target(String BehaviorName, Pony initiator, Interaction interaction) {
		for (Behavior behavior : Behaviors) {
			if (BehaviorName.trim().equalsIgnoreCase(behavior.Name.trim())) {
				this.SelectBehavior(behavior);
				for (effect Effect : current_behavior.Effects) {
					Effect.already_played_for_currentbehavior = false;
				}
				break;
			}
		}
		
		interaction.Initiator = initiator;
		Is_Interaction_Initiator = false;
		Current_Interaction = interaction;
		Is_Interacting = true;
	}
	
	// Teleport the Pony randomly if it ends up somewhere off screen
	public void Teleport() {
		GraphicsDevice[] UsableScreens = WinMain.screens_to_use;
		
		// Select a random monitor to teleport to
		int dice = 0;
		GraphicsDevice random_screen = null;
		Point teleport_location = new Point();
		
		for (int i = 0; i < 300; i++) {
			dice = WinMain.rand.nextInt(UsableScreens.length);
			random_screen = UsableScreens[dice];
			// Then select a random location to appear at
			Rectangle screenBounds = random_screen.getDefaultConfiguration().getBounds(); 
		    teleport_location = new Point(WinMain.rand.nextInt((int)screenBounds.getWidth()) + (int)screenBounds.getMinX(), WinMain.rand.nextInt((int)screenBounds.getHeight()) + (int)screenBounds.getMinY());
		    
		    if (IsPonyInAvoidanceArea(teleport_location, random_screen) == false) break;
		}
	
	    // Finally, go there
	    Form.setLocation(teleport_location);
	}

	// Update and move the Pony
	public void Update() {
		if (Behaviors.size() > 0) {
			if (Form.should_be_sleeping) {
				if (sleeping)
					return;
				else
					sleep();
			} else {
				if (sleeping)
					wake_up();
			}
			
			if (current_behavior == null) { // If we have no behavior, select a random one
				for (Effect_Form effect : Active_Effects) { // Clear any lingering effects
					if (effect.Close_On_New_Behavior == true)
						effect.setVisible(false);
				}
				Cancel_Interaction();
				SelectBehavior(null);
			} else if ((current_behavior.end_time.getTime() - (new Date()).getTime()) <= 0 && Cursor_Halt == false && Form.ManualControl == false) { // If the behavior has run its course, select a new one
				if (current_behavior.End_Line != null) {
					Form.Pony_Speak(Current_Screen, current_behavior.End_Line, false);
				}
				
				if (current_behavior.Linked_Behavior != null) { // If we have a linked behavior, select that one next
					SelectBehavior(current_behavior.Linked_Behavior);
				} else { // Otherwise select a random one
					SelectBehavior(null);
				}
			} else if ((current_behavior.end_time.getTime() - (new Date()).getTime()) <= 0 && Cursor_Halt == true && Form.ManualControl == false) {
				SelectBehavior(current_behavior);
			}
				        
	        //if we should be, or are halted because we are/were in the cursor's way, 
	        //either go to mouseover mode, or come out of it.
	        if (Cursor_Halt || Is_cursor_halted) {
	            MouseOver_Mode();
	        }
	        
	        // Move the Pony
	        Move();
		}
	}
	
	public void wake_up() {
		sleeping = false;
	}
}
